import { Metadata } from "next";
import { getListingById } from "@/src/api/listings";
import AuctionInfo from "./AuctionInfo";

export async function generateMetadata({ params }: any): Promise<Metadata> {
  const { id, categoryName, productName } = params;

  try {
    const res = await getListingById(id);
    const listing = res?.listing;

    const title = listing?.product_name || "Auction Item";
    const description =
      listing?.description?.trim().substring(0, 160) ||
      "Check out this amazing auction item!";

    const image =
      typeof listing?.images?.[0] === "string"
        ? listing.images[0]
        : "https://reservitt.com/storage/banner_images/1738062483.png";

    return {
      title: "Reservitt",
      description,
      openGraph: {
        title,
        description,
        url: `${process.env.NEXT_PUBLIC_PRODUCT_URL}/auction/${id}/${categoryName}/${productName}`,
        images: [
          {
            url: image,
            width: 800,
            height: 600,
            alt: title,
          },
        ],
        type: "website",
      },
      twitter: {
        card: "summary_large_image",
        title,
        description,
        images: [image],
      },
    };
  } catch {
    return {
      title: "Auction Item",
      description: "Check out this auction item!",
    };
  }
}

// src/app/auction/[id]/[categoryName]/[productName]/page.tsx
export default function Page() {
  // params is available here if needed
  return <AuctionInfo />;
}
